#ifndef _VUVOLUMEREGULARUNIMODAL2D_H_
#define _VUVOLUMEREGULARUNIMODAL2D_H_

#include "../unimodal.h"

class vu1111;
typedef vu1111 vuVolumeRegularUnimodal2d;

//! This is the base class for Regular Unimodal 2D renderers.
class vu1111 : public vu111
{
public:
	/**constructor

	This will initially set the size of both dimensions to 0.
	*/
    vu1111();
    	//!copy constructor, deep copy
    vu1111(vu1111& inst);
    	//!destructor
    virtual ~vu1111();

    	//! Assignment operator
    vu1111& operator=(vu1111& rhs);

    	//! sets the size of the first dimension to val
    void setDim1Size(int val);
    	//! returns the current size of the first dimensions
    int getDim1Size(void);
    	//! sets the size of the second dimension to val
    void setDim2Size(int val);
    	//! returns the current suze of the second dimension
    int getDim2Size(void);

protected:
	//! this is the size of the 1st dimension
    int m_Dim1Size;
    	//! this is the size of the second dimension
    int m_Dim2Size;

};

#endif
