#ifndef _VUVOLUMEREGULARMULTIMODAL4D_H_
#define _VUVOLUMEREGULARMULTIMODAL4D_H_

#include "../multimodal.h"

class vu1123;
typedef vu1123 vuVolumeRegularMultimodal4d;

/** this is the bsae class from which regular, multimodal, 4d renderers will be derived
This will provide the dimension handling capabilities to those methods
(ie get the number of increments of the dataset in each dimension */
class vu1123 : public vu112
{
public:

	/** constructor

	This will initialize the number of increments in each dimension to be 0 */
    vu1123();

    	//! copy constructor, this will perform a deep copy.
    vu1123(const vu1123& inst);

    	//! destuctor
    virtual ~vu1123();

    	//! assignment operator
    vu1123& operator=(const vu1123& rhs);

    	/** this will return the size of the dataset in the first dimension
	 (ie, this will return the number of increments along the first dimension). */
    dword getDim1Size() const;
    dword getDim2Size() const;
    dword getDim3Size() const;
    dword getDim4Size() const;

protected:
    dword m_Dim1Size;
    dword m_Dim2Size;
    dword m_Dim3Size;
    dword m_Dim4Size;
};

#endif
