#ifndef _VUVOLUMEREGULARMULTIMODAL3D_H_
#define _VUVOLUMEREGULARMULTIMODAL3D_H_

#include "../multimodal.h"

class vu1122;
typedef vu1122 vuVolumeRegularMultimodal3d;

/** this is the base class from which Regular, Multimodal, 3d renderers will be derived
This provides the capabilities to manipulate dimensional information */
class vu1122 : public vu112
{
public:
	/** constructor,

	This will set the size of each dimension to be 0. */
    vu1122();

    	//! copy constructor, performs a deep copy
    vu1122(const vu1122& inst);

    	//! destructor
    virtual ~vu1122();

    	//! assignment operator
    vu1122& operator=(const vu1122& rhs);

    	/** this will return the size of the dataset in the 1st diemnsion
	 (ie., the number of increments that exist in the dataset along the first dimension). */
    dword getDim1Size() const;

    	/** this will return the size of the dataset in the 2nd diemnsion
	 (ie., the number of increments that exist in the dataset along the second dimension). */
    dword getDim2Size() const;

    	/** this will return the size of the dataset in the 3rd diemnsion
	 (ie., the number of increments that exist in the dataset along the third dimension). */
    dword getDim3Size() const;

protected:
	/** this is the size of the dataset in the first dimension
	 (ie, the number of increments along the first dimension). */
    dword m_Dim1Size;
	/** this is the size of the dataset in the second dimension
	 (ie, the number of increments along the second dimension). */
    dword m_Dim2Size;
	/** this is the size of the dataset in the third dimension
	 (ie, the number of increments along the third dimension). */
    dword m_Dim3Size;
};

#endif
