#ifndef _VUVOLUMEREGULARMULTIMODAL2D_H_
#define _VUVOLUMEREGULARMULTIMODAL2D_H_

#include "../multimodal.h"

class vu1121;
typedef vu1121 vuVolumeRegularMultimodal2d;
/** this is the base class for Regular, MultiModal, 2D renderers

This will implement the dimension handling capabilities (set and retrieve the size of the datasets in
each dimension).*/
class vu1121 : public vu112
{
public:
	/** constructor,

	this will set the size of the first and second dimensoins to be 0 */
    vu1121();

    	//! copy constructor, this will perform a deep copy.
    vu1121(const vu1121& inst);

    	//! destructor
    virtual ~vu1121();

    	//! assignment operator
    vu1121& operator=(const vu1121& rhs);

    	/** this will return the size of the first dimension
	 (ie, how many increments exist in the dataset along the first dimension). */
    dword getDim1Size(void) const;
    	/** this will return the size of the second dimension
	 (ie, how many increments exist in the datset along the second dimension). */
    dword getDim2Size(void) const;

protected:

	/** this is the size of the first dimension
	 (ie., how many increments exist in the first dimension). */
    dword m_Dim1Size;

    	/** this is the ize of the second dimension
	 (ie., how many increments exist in the second dimension). */
    dword m_Dim2Size;
};

#endif
