#ifndef _VUVOLUMERECTILINEARUNIMODAL4D_H_
#define _VUVOLUMERECTILINEARUNIMODAL4D_H_

#include "../unimodal.h"

class vu1213;
typedef vu1213 vuVolumeRectilinearUnimodal4d;

/** this is the base class from which Rectilinear, Unimodal, 4d renderers will be derived
This class will provide the capability to set and change the range of the dataset in each dimension */
class vu1213 : public vu121
{
public:
	//! constructor
    vu1213();
    	//!copy constructor
    vu1213(vu1213& inst);
    	//!destructor
    virtual ~vu1213();

    	//! assignment operator
    vu1213& operator=(vu1213& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the firt dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of the third dimesnion of the dataset
    int getDim3Size(void);
    	//! this will set the range of the fourth dimension of the dataset to be val
    void setDim4Size(int val);
    	//! this will return the range of the fourth dimension of the dataset
    int getDim4Size(void);

protected:
	//! This is the range of the first dimension of the dataset
    int m_Dim1Size;
    	//! This is the range of the second dimension of the dataset
    int m_Dim2Size;
    	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;
    	//! This is the range of the fourth dimension of the dataset
    int m_Dim4Size;

};

#endif
