#ifndef _VUVOLUMERECTILINEARUNIMODAL3D_H_
#define _VUVOLUMERECTILINEARUNIMODAL3D_H_

#include "../unimodal.h"

class vu1212;
typedef vu1212 vuVolumeRectilinearUnimodal3d;

/** this is the base class for Rectilinear, Unimodal, 3d volume renderers
This implements the capabilities to handle the range of the dataset in each dimension
(NB, the range is from 0 to an integer*/
class vu1212 : public vu121
{
public:
	//! constructor
    vu1212();
    	//! copy constructor, performs a deep copy
    vu1212(vu1212& inst);

    	//! destructor
    virtual ~vu1212();

    	//! assignment operator
    vu1212& operator=(vu1212& rhs);

    	//! this will set the range of the first dimension to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension
    int getDim1Size(void);
    	//! this will set the range of the second dimension to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension
    int getDim2Size(void);
    	//! this will set the range of the third dimension to be val
    void setDim3Size(int val);
    	//! this will return the range of the third dimension
    int getDim3Size(void);

protected:
	//! this is the range of the data set in the first dimension
    int m_Dim1Size;
	//! this is the range of the data set in the second dimension
    int m_Dim2Size;
	//! this is the range of the data set in the third dimension
    int m_Dim3Size;

};

#endif
