#ifndef _VUVOLUMERECTILINEARUNIMODAL2D_H_
#define _VUVOLUMERECTILINEARUNIMODAL2D_H_

#include "../unimodal.h"

class vu1211;
typedef vu1211 vuVolumeRectilinearUnimodal2d;

/** this is the base class from which Rectilinear, Unimodal, 2d renderers will be derived
This class will provide the capabilities handle the size of the dimensions of the datasets

(ie, the number of increments in each dimension). */
class vu1211 : public vu121
{
public:
	/** constructor

	this will set each dimension to size 0 (ie, no data) */
    vu1211();
    	//! copy constructor, performs a deep copy
    vu1211(vu1211& inst);

    	//! destructor
    virtual ~vu1211();

    	//! assignment operator
    vu1211& operator=(vu1211& rhs);

    	/** this will set the size of the dataset in the first dimension to be val
	 (ie., the number of increments in the first dimension */
    void setDim1Size(int val);

    	/** this will return the size of the dataset in the first dimension
	 (ie., the number of increments in the first dimension */
    int getDim1Size(void);

	/** this will set the size of the dataset in the second dimension to be val
	 (ie., the number of increments in the second dimension */
    void setDim2Size(int val);

    	/** this will return the size of the dataset in the second dimension
	 (ie., the number of increments in the second dimension */
    int getDim2Size(void);

protected:

	/** this is the size of the dataset in the first dimension */
    int m_Dim1Size;
	/** this is the size of the dataset in the second dimension */
    int m_Dim2Size;

};

#endif
