#ifndef _VUVOLUMERECTILINEARMULTIMODAL4D_H_
#define _VUVOLUMERECTILINEARMULTIMODAL4D_H_

#include "../multimodal.h"

class vu1223;
typedef vu1223 vuVolumeRectilinearMultimodal4d;

/** this is the base class from which Rectilinear, Multimodal, 4d renderers will be derived
This class will provide the functionality to handle the range of the dataset in each dimension */
class vu1223 : public vu122
{
public:
	//! constructor
    vu1223();
    	//! copy constructor
    vu1223(vu1223& inst);
    	//!destructor
    virtual ~vu1223();

    	//! assignment operator
    vu1223& operator=(vu1223& rhs);

    	//! This will set the range of the dataset in the first dimension to be val
    void setDim1Size(int val);
	//! This will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! This will set the range of the dataset in the second dimension to be val
    void setDim2Size(int val);
	//! This will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! This will set the range of the dataset in the third dimension to be val
    void setDim3Size(int val);
	//! This will return the range of the third dimension of the dataset
    int getDim3Size(void);
    	//! This will set the range of the dataset in the fourth dimension to be val
    void setDim4Size(int val);
	//! This will return the range of the fourth dimension of the dataset
    int getDim4Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;
	//! this is the range of the fourth dimension of the dataset
    int m_Dim4Size;

};

#endif
