#ifndef _VUVOLUMERECTILINEARMULTIMODAL3D_H_
#define _VUVOLUMERECTILINEARMULTIMODAL3D_H_

#include "../multimodal.h"

class vu1222;
typedef vu1222 vuVolumeRectilinearMultimodal3d;

/** This is the base class from which Rectilinear, Multimodal, 3D renderers will be derived.
This calss will provide the functionality to handle the range of the dataset in each dimension */
class vu1222 : public vu122
{
public:
	//! constructor
    vu1222();
    	//! copy constructor, performs a deep copy
    vu1222(vu1222& inst);
    	//! destructor
    virtual ~vu1222();

    	//! assignment operator
    vu1222& operator=(vu1222& rhs);

    	//! This will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! This will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! This will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! This will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! This will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! This will return the range of the third dimension of the dataset
    int getDim3Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
    	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
    	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;

};

#endif
