#ifndef _VUVOLUMERECTILINEARMULTIMODAL2D_H_
#define _VUVOLUMERECTILINEARMULTIMODAL2D_H_

#include "../multimodal.h"

class vu1221;
typedef vu1221 vuVolumeRectilinearMultimodal2d;

/** This is the base class from which Rectilinear, Multimodal, 2d renderers will be derived.
This contains the functionality to handle the range of the datasets in each dimension */
class vu1221 : public vu122
{
public:
	//! constructor
    vu1221();
    	//! copy constructor
    vu1221(vu1221& inst);
    	//!destructor
    virtual ~vu1221();

    	//! assignment operator
    vu1221& operator=(vu1221& rhs);

    	//! This will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimesnion of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
    	//! this is the range of the second dimension of the dataset.
    int m_Dim2Size;

};

#endif
