#ifndef __VOLUME_LIGHTFIELD_H__
#define __VOLUME_LIGHTFIELD_H__

#include "../volume.h"

class vu16;
typedef vu16 vuVolumeLightfield;

//!The base class for lightfield volume data in the vuVolume data tree.

class vu16 : public vu1
{
protected:
  /*!Asserts that the file is lightfield data and reads the associated
    information.
  */

  /*!This method reads in the general information for all lightfield data sets.
    It also asserts whether the data is indeed lightfield or not.
    \return True if successful (data is lightfield), false otherwise.
  */
  virtual bool read(FILE *file);

  //!Writes the general lightfield data information to the file.
  /*!\return True if successful, false otherwise.
   */
  virtual bool write(FILE *file);
};

#endif /* __VOLUME_LIGHTFIELD_H__ */
