#include <stdio.h>
#include "lightfield.h"

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

bool vu16::read(FILE *file)
{
  int ret = 0;
  int len = 0;

  bool success = vu1::read(file);
  if (!success) return false;
  //Read in the Dataset type, checking if it's a fixel volume
  ret = fscanf(file,"DATASET LIGHTFIELD %n",&len);
  if (len < 19) return setInvalidFormatError();

  return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu16::write(FILE *file)
{
  int ret = 0;

  bool success = vu1::write(file);
  if (!success) return false;

  //Write the Dataset type
  ret = fprintf(file,"DATASET LIGHTFIELD\n");
    
  if (ret > 0)
    return true;
  else
    return setWriteError();
}
