#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_H_

#include <stdio.h>
#include "vuString.h"
#include "../lightfield.h"

//!The base class for lightfield unimodal volume data in the vuVolume tree.

class vu161;
typedef vu161 vuVolumeLightfieldUnimodal;

class vu161 : public vu16
{
public:
    //!Returns the name of the data set.
    /*!This is a short name to describe the data set, such as temperature
       or opacity.  It serves to differentiate different types of data within
       the same file.
    */
    const char *getDataName(void) const;

protected:
    /*!Asserts that the file is unimodal data and reads the associated
       information.
    */
    /*!This method reads in the general information for all unimodal 
       data sets. It also asserts whether the data is indeed unimodal
       or not.
       \return True if successful (data is unimodal), false otherwise.
    */
    virtual bool read(FILE *file);

    //!Writes the general unimodal data information to the file.
    /*!\return True if successful, false otherwise.
    */
    virtual bool write(FILE *file);

protected:
    //!The name of the data set.
    vuString m_DataName;    
};

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_H_ */
