#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_VU_SPHERIC_FILTER_FACTORY_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_VU_SPHERIC_FILTER_FACTORY_H_

#include "vuSphericFilter.h"

#include "vuFilter/vuSphLfFlt_BestMatch.h"
#include "vuFilter/vuSphLfFlt_Line.h"
#include "vuFilter/vuSphLfFlt_Triangle.h"
#include "vuFilter/vuSphLfFlt_Z_Axis.h"
#include "vuFilter/vuSphLfFlt_XZ_Axis.h"
#include "vuFilter/vuSphLfFlt_XYZ_Axis.h"
#include "vuFilter/vuSphLfFlt_All.h"
#include "vuFilter/vuSphLfFlt_FitAngle.h"
#include "vuFilter/vuSphLfFlt_Nearest.h"

template <int SIZE, class TYPE>
class vuSphericFilterFactory
{
 public:
  static vuSphericFilter<SIZE,TYPE> *getFilter(dword idx);

  //!creates spherical lightfield filters
  //!\returns a pointer to a newed filter
  static vuSphericFilter<SIZE,TYPE> *getFilter(const vuString &filterName);

  static void getFilterNames(vuString* &filterNames, dword &numberOfNames);
};

template class vuSphericFilterFactory<1,byte>;
template class vuSphericFilterFactory<2,byte>;
template class vuSphericFilterFactory<3,byte>;
template class vuSphericFilterFactory<1,float>;
template class vuSphericFilterFactory<2,float>;
template class vuSphericFilterFactory<3,float>;

typedef vuSphericFilterFactory<1,byte>  vuSphericFilterFactory1B;
typedef vuSphericFilterFactory<2,byte>  vuSphericFilterFactory2B;
typedef vuSphericFilterFactory<3,byte>  vuSphericFilterFactory3B;
typedef vuSphericFilterFactory<1,float> vuSphericFilterFactory1F;
typedef vuSphericFilterFactory<2,float> vuSphericFilterFactory2F;
typedef vuSphericFilterFactory<3,float> vuSphericFilterFactory3F;


#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_VU_SPHERIC_FILTER_FACTORY_H_ */
