#include "vuSphericFilterFactory.h"

template <int S, class T>
vuSphericFilter<S,T> *vuSphericFilterFactory<S,T>::getFilter(dword idx)
{
  static vuString *filterNames = NULL;
  static dword    count        = 0;
   
  if (filterNames == NULL)
    vuSphericFilterFactory<S,T>::getFilterNames(filterNames, count);

  if (idx < count)
    return getFilter(filterNames[idx]);
  else
    return NULL;
}


template <int S, class T> vuSphericFilter<S,T> *
vuSphericFilterFactory<S,T>::getFilter(const vuString &filterName)
{
  if (filterName == "BestMatch")
    return new vuSphLfFlt_BestMatch<S,T>("BestMatch");
  else if (filterName == "Line")
    return new vuSphLfFlt_Line<S,T>("Line");
  else if (filterName == "Triangle")
    return new vuSphLfFlt_Triangle<S,T>("Triangle");
  else if (filterName == "Z-Axis")
    return new vuSphLfFlt_Z_Axis<S,T>("Z-Axis");
  else if (filterName == "XZ-Axis")
    return new vuSphLfFlt_XZ_Axis<S,T>("XZ-Axis");
  else if (filterName == "XYZ-Axis")
    return new vuSphLfFlt_XYZ_Axis<S,T>("XYZ-Axis");
  else if (filterName == "All")
    return new vuSphLfFlt_All<S,T>("All");
  else if (filterName == "Fit Angle")
    return new vuSphLfFlt_FitAngle<S,T>("Fit Angle");
  else if (filterName == "Nearest")
    return new vuSphLfFlt_Nearest<S,T>("Nearest");
  else
    return NULL;
}

template <int S, class T>
void vuSphericFilterFactory<S,T>::getFilterNames(vuString* &filterNames,
						 dword &numberOfNames)
{
  static const dword    count         = 9;
  static const vuString result[count] = { "BestMatch", 
					  "Line",
					  "Triangle",
                                          "Z-Axis",
                                          "XZ-Axis",
                                          "XYZ-Axis",
                                          "All",
                                          "Fit Angle",
                                          "Nearest"};
 

  filterNames   = (vuString *)result;
  numberOfNames = count;
}
