#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_VUSPHERICFILTER_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_VUSPHERICFILTER_H_

#include "spheric.h"
#include "General/vuMisc/vuFilter.h"
#include "General/vuLightfield/vuSphericView.h"
#include "General/vuLightfield/vuSphericViewFilter.h"

template <int SIZE, class TYPE> class vu1611;

class vuSphericFilter_ST : public vuFilter
{
 public:
  vuSphericFilter_ST();
  vuSphericFilter_ST(const vuString& filterName);
  virtual ~vuSphericFilter_ST();
  virtual void preview(int hint=0);
};

template <int SIZE, class TYPE>
class vuSphericFilter : public vuSphericFilter_ST 
{

 public:
  vuSphericFilter();
  vuSphericFilter(const vuString &filterName);

  vuSphericFilter(const vuSphericFilter<SIZE,TYPE> &other);

  virtual ~vuSphericFilter();

  //!Sets the volume, on which the filter is applied
  void setVolume(vu1611<SIZE,TYPE> *volume);

  //!Returns the volume
  vu1611<SIZE,TYPE> *getVolume();

  //! filters the views
  //!This method holds the functionality of the filter.
  //!It has to be implemented by subclasses.
  virtual
  void calcFilteredViews(vuSphericView<SIZE,TYPE>**& views, dword& count) = 0;
  
  //! this function should be used to apply the filtered views to
  //! the according viewFilter
  void applyFilteredViews(vuSphericViewFilter<SIZE,TYPE> *viewFilter);

  bool operator==(const vuSphericFilter<SIZE,TYPE> &other);

  bool operator!=(const vuSphericFilter<SIZE,TYPE> &other);

 protected:
  //!The volume, on which the filter is applied
  vu1611<SIZE,TYPE> *m_volume;

  void log(const char *msg);

  //! computes the &count nearest views, according to the camera
  //! \note returns a 'newed' index list with length &count
  //! \note &count might be changed!!!
  bool getNearestViews(dword* &idxList, dword &count);
  bool getNearestViews(dword* &idxList, dword &count, vuVector lookFrom);

 public:
  static bool getNearestViews(dword* &idxList, dword &count,
			      vuVector lookFrom, dword numOfViews,
			      vuSphericView<SIZE,TYPE>* &views);

  static bool getNearestViews(dword* &idxList, dword &count,
			      vuVector lookFrom,dword numOfViews,
			      vuSphericView<SIZE,TYPE>** views);
};

template class vuSphericFilter<1,byte>;
template class vuSphericFilter<2,byte>;
template class vuSphericFilter<3,byte>;
template class vuSphericFilter<1,float>;
template class vuSphericFilter<2,float>;
template class vuSphericFilter<3,float>;

typedef vuSphericFilter<1,byte>  vuSphericFilter1B;
typedef vuSphericFilter<2,byte>  vuSphericFilter2B;
typedef vuSphericFilter<3,byte>  vuSphericFilter3B;
typedef vuSphericFilter<1,float> vuSphericFilter1F;
typedef vuSphericFilter<2,float> vuSphericFilter2F;
typedef vuSphericFilter<3,float> vuSphericFilter3F;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_VUSPHERICFILTER_H_ */
