#include "vuSphericFilter.h"
#include "General/vuCamera/vuCamera.h"

vuSphericFilter_ST::vuSphericFilter_ST() 
{
}

vuSphericFilter_ST::vuSphericFilter_ST(const vuString& filterName) 
  : vuFilter(filterName)
{
}

vuSphericFilter_ST::~vuSphericFilter_ST()
{
}

void vuSphericFilter_ST::preview(int hint)
{
}

// -------------------------------------------------------------------------

template <int S, class T>
vuSphericFilter<S,T>::vuSphericFilter()
{
  m_volume    = NULL;
}

template <int S, class T>
vuSphericFilter<S,T>::vuSphericFilter(const vuString &filterName)
  : vuSphericFilter_ST(filterName)
{
  m_volume     = NULL;
}

template <int S, class T>
vuSphericFilter<S,T>::vuSphericFilter(const vuSphericFilter<S,T> &other)
{ 
  if (*this != other) {
    m_volume     = other.m_volume;
  }
}

template <int S, class T>
vuSphericFilter<S,T>::~vuSphericFilter()
{
}

template <int S, class T>
void vuSphericFilter<S,T>::setVolume(vu1611<S,T> *volume)
{
  m_volume = volume;
}

template <int S, class T>
vu1611<S,T> *vuSphericFilter<S,T>::getVolume()
{
  return m_volume;
}

template <int S, class T>
void vuSphericFilter<S,T>::log(const char *msg)
{
  cerr << msg << endl;
}

template <int S, class T> void vuSphericFilter<S,T>::
applyFilteredViews(vuSphericViewFilter<S,T> *viewFilter)
{
  dword              count   = 0;
  vuSphericView<S,T> **views = NULL;
  
  calcFilteredViews(views, count);
  viewFilter->setNumberOfViews(count);

  for (dword i=0; i<count; i++) {
    viewFilter->setView(i, views[i]);
  }
  CHECKNDELETE(views);
}

template <int S, class T>
bool vuSphericFilter<S,T>::getNearestViews(dword* &idxList, dword &count)
{
  if (!m_volume) {
    log("vuSphFlt.getNearestView(): no volume set!");
    return false;
  }

  vuCamera *camera = m_volume->getCameraPtr();

  if (!camera) {
    log("vuSphFlt.getNearestView(): no camera set!");
    return false;
  }

  vuVector lookFrom = camera->getLookAtVector().makeUnit() * -1;

  return vuSphericFilter<S,T>::getNearestViews(idxList, count, lookFrom,
					       m_volume->getNumberOfViews(),
					       m_volume->getViews());
}

template <int S, class T>
bool vuSphericFilter<S,T>::getNearestViews(dword* &idxList, dword &count,
					   vuVector lookFrom)
{
  if (!m_volume) {
    log("vuSphFlt.getNearestView(): no volume set!");
    return false;
  }
  return vuSphericFilter<S,T>::getNearestViews(idxList, count, lookFrom,
					       m_volume->getNumberOfViews(),
					       m_volume->getViews());
}

template <int S, class T> bool vuSphericFilter<S,T>::
getNearestViews(dword* &idxList, dword &count, vuVector lookFrom,
		dword numOfViews, vuSphericView<S,T>* &views)
{
  if (count == 0) { // count=> how many views have to be calculated?
    cerr << "vuSphFlt.getNearestView(): count is 0!" << endl;
    return false;
  }
  if (idxList != NULL) {
    cerr << "vuSphFlt.getNearestView():idxList is not initalized" << endl;
    return false;
  }
  if (numOfViews == 0) {
    cerr << "vuSphFlt.getNearestView(): numOfViews is 0!" << endl;
    return false;
  }
  
  dword    i;
  float    *dots = NULL; // holds the last computed dot products

  if (count > numOfViews) count = numOfViews; 

  idxList = new dword[count];
  dots    = new float[count];

  for (i=0; i<count; i++) {
    idxList[i] = 0;
    dots[i]    = -1.0f;
  }

  for(i=0; i<numOfViews; i++) {
    vuVector from1     = views[i].getLookFrom().makeUnit();
    float    dot       = lookFrom.dot(from1);
    float    lastDot   = 0.0f; 
    dword    lastIdx   = 0;
    bool     didFound  = false;

    for (dword j=0; j<count; j++) {
      if (didFound) {
	float tmpDot = dots[j];
	dword tmpIdx = idxList[j];

	dots[j]    = lastDot;
	idxList[j] = lastIdx;

	lastDot = tmpDot;
	lastIdx = tmpIdx;
      }
      else if (dot > dots[j]) {
	lastDot = dots[j];
	lastIdx = idxList[j];

	dots[j]     = dot;
	idxList[j] = i;

	didFound = true;
      }
    }
  }
  delete [] dots;
  return true;
}

template <int S, class T> bool vuSphericFilter<S,T>::
getNearestViews(dword* &idxList, dword &count, vuVector lookFrom,
		dword numOfViews, vuSphericView<S,T>** views)
{
  if (count == 0) { // count=> how many views have to be calculated?
    cerr << "vuSphFlt.getNearestView(): count is 0!" << endl;
    return false;
  }
  if (idxList != NULL) {
    cerr << "vuSphFlt.getNearestView():idxList is not initalized" << endl;
    return false;
  }
  if (numOfViews == 0) {
    cerr << "vuSphFlt.getNearestView(): numOfViews is 0!" << endl;
    return false;
  }
  
  dword    i;
  float    *dots = NULL; // holds the last computed dot products

  if (count > numOfViews) count = numOfViews; 

  idxList = new dword[count];
  dots    = new float[count];

  for (i=0; i<count; i++) {
    idxList[i] = 0;
    dots[i]    = -1.0f;
  }

  for(i=0; i<numOfViews; i++) {
    vuVector from1     = views[i]->getLookFrom().makeUnit();
    float    dot       = lookFrom.dot(from1);
    float    lastDot   = 0.0f; 
    dword    lastIdx   = 0;
    bool     didFound  = false;

    for (dword j=0; j<count; j++) {
      if (didFound) {
	float tmpDot = dots[j];
	dword tmpIdx = idxList[j];

	dots[j]    = lastDot;
	idxList[j] = lastIdx;

	lastDot = tmpDot;
	lastIdx = tmpIdx;
      }
      else if (dot > dots[j]) {
	lastDot = dots[j];
	lastIdx = idxList[j];

	dots[j]     = dot;
	idxList[j] = i;

	didFound = true;
      }
    }
  }
  delete [] dots;
  return true;
}

template <int S, class T>
bool vuSphericFilter<S,T>::operator==(const vuSphericFilter<S,T> &other)
{
  if (this == &other) return true;
  else return false;
}

template <int S, class T>
bool vuSphericFilter<S,T>::operator!=(const vuSphericFilter<S,T> &other)
{
  return !(operator==(other));
}
