#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Triangle_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Triangle_H_

#include "../vuSphericFilter.h"

template <int SIZE, class TYPE>
class vuSphLfFlt_Triangle : public vuSphericFilter<SIZE,TYPE>
{
 protected:
  using vuSphericFilter<SIZE,TYPE>::m_volume;
  using vuSphericFilter<SIZE,TYPE>::getNearestViews;
 public:
  vuSphLfFlt_Triangle(const vuString& filterName);

  //! This filter simple finds the best 3 matching views
  void calcFilteredViews(vuSphericView<SIZE,TYPE>**& views, dword& count);
};

template class vuSphLfFlt_Triangle<1,byte>;
template class vuSphLfFlt_Triangle<2,byte>;
template class vuSphLfFlt_Triangle<3,byte>;
template class vuSphLfFlt_Triangle<1,float>;
template class vuSphLfFlt_Triangle<2,float>;
template class vuSphLfFlt_Triangle<3,float>;

typedef vuSphLfFlt_Triangle<1,byte>  vuSphLfFlt_Triangle1B;
typedef vuSphLfFlt_Triangle<2,byte>  vuSphLfFlt_Triangle2B;
typedef vuSphLfFlt_Triangle<3,byte>  vuSphLfFlt_Triangle3B;
typedef vuSphLfFlt_Triangle<1,float> vuSphLfFlt_Triangle1F;
typedef vuSphLfFlt_Triangle<2,float> vuSphLfFlt_Triangle2F;
typedef vuSphLfFlt_Triangle<3,float> vuSphLfFlt_Triangle3F;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Triangle_H_ */
