#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Nearest_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Nearest_H_

#include "../vuSphericFilter.h"

template <int SIZE, class TYPE>
class vuSphLfFlt_Nearest : public vuSphericFilter<SIZE,TYPE>
{
 protected:
  using vuSphericFilter<SIZE,TYPE>::m_volume;
  using vuSphericFilter<SIZE,TYPE>::getNearestViews;
 public:
  vuSphLfFlt_Nearest(const vuString& filterName);

  //! This filter simple finds the best 2 matching views
  void calcFilteredViews(vuSphericView<SIZE,TYPE>**& views, dword& count);

  //! Set the number of views
  void setNumberOfViews(int hint);
  //! Get the number of views
  dword getNumberOfViews();
  
 protected:
  dword m_NumberOfViews;
};

template class vuSphLfFlt_Nearest<1,byte>;
template class vuSphLfFlt_Nearest<2,byte>;
template class vuSphLfFlt_Nearest<3,byte>;
template class vuSphLfFlt_Nearest<1,float>;
template class vuSphLfFlt_Nearest<2,float>;
template class vuSphLfFlt_Nearest<3,float>;

typedef vuSphLfFlt_Nearest<1,byte>  vuSphLfFlt_Nearest1B;
typedef vuSphLfFlt_Nearest<2,byte>  vuSphLfFlt_Nearest2B;
typedef vuSphLfFlt_Nearest<3,byte>  vuSphLfFlt_Nearest3B;
typedef vuSphLfFlt_Nearest<1,float> vuSphLfFlt_Nearest1F;
typedef vuSphLfFlt_Nearest<2,float> vuSphLfFlt_Nearest2F;
typedef vuSphLfFlt_Nearest<3,float> vuSphLfFlt_Nearest3F;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Nearest_H_ */
