#include "vuSphLfFlt_Nearest.h"

template <int SIZE, class TYPE>
vuSphLfFlt_Nearest<SIZE,TYPE>::vuSphLfFlt_Nearest(const vuString& filterName)
  : vuSphericFilter<SIZE,TYPE>(filterName)
{
  m_NumberOfViews = 1;
}

template <int S, class T> void vuSphLfFlt_Nearest<S,T>::
calcFilteredViews(vuSphericView<S,T>**& views,dword& count)
{
  CHECKNDELETE(views);
  count = 0;
  
  if (m_volume == NULL) return;

  dword *idxList = NULL;
  count = m_NumberOfViews;

  if (!getNearestViews(idxList, count)) return;

  views = new vuSphericView<S,T>*[count];
  
  for (dword i=0; i<count; i++) {
    views[i] = m_volume->getView(idxList[i]);
  }
  delete [] idxList;
}

template <int SIZE, class TYPE>
void vuSphLfFlt_Nearest<SIZE,TYPE>::setNumberOfViews(int numberOfViews)
{
  if (numberOfViews < 0) numberOfViews = 1;
  m_NumberOfViews = numberOfViews;

  if (m_volume == NULL) return;
  
  if (m_volume->getNumberOfViews() < m_NumberOfViews)
    m_NumberOfViews = m_volume->getNumberOfViews();
}


template <int SIZE, class TYPE>
dword vuSphLfFlt_Nearest<SIZE,TYPE>::getNumberOfViews()
{
  return m_NumberOfViews;
}
