#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Line_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Line_H_

#include "../vuSphericFilter.h"

template <int SIZE, class TYPE>
class vuSphLfFlt_Line : public vuSphericFilter<SIZE,TYPE>
{
 protected:
  using vuSphericFilter<SIZE,TYPE>::m_volume;
  using vuSphericFilter<SIZE,TYPE>::getNearestViews;
 public:
  vuSphLfFlt_Line(const vuString& filterName);

  //! This filter simple finds the best 2 matching views
  void calcFilteredViews(vuSphericView<SIZE,TYPE>**& views, dword& count);
  
  //! preview
  virtual void preview(int hint);
};

template class vuSphLfFlt_Line<1,byte>;
template class vuSphLfFlt_Line<2,byte>;
template class vuSphLfFlt_Line<3,byte>;
template class vuSphLfFlt_Line<1,float>;
template class vuSphLfFlt_Line<2,float>;
template class vuSphLfFlt_Line<3,float>;

typedef vuSphLfFlt_Line<1,byte>  vuSphLfFlt_Line1B;
typedef vuSphLfFlt_Line<2,byte>  vuSphLfFlt_Line2B;
typedef vuSphLfFlt_Line<3,byte>  vuSphLfFlt_Line3B;
typedef vuSphLfFlt_Line<1,float> vuSphLfFlt_Line1F;
typedef vuSphLfFlt_Line<2,float> vuSphLfFlt_Line2F;
typedef vuSphLfFlt_Line<3,float> vuSphLfFlt_Line3F;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_Line_H_ */
