#include "vuSphLfFlt_Line.h"

template <int SIZE, class TYPE>
vuSphLfFlt_Line<SIZE,TYPE>::vuSphLfFlt_Line(const vuString& filterName)
  : vuSphericFilter<SIZE,TYPE>(filterName)
{
}

template <int S, class T> void vuSphLfFlt_Line<S,T>::
calcFilteredViews(vuSphericView<S,T>**& views,dword& count)
{
  CHECKNDELETE(views);

  dword *idxList = NULL;
  count = 2;

  if (!getNearestViews(idxList, count)) return;

  views = new vuSphericView<S,T>*[count];
  
  for (dword i=0; i<count; i++) {
    views[i] = m_volume->getView(idxList[i]);
  }
  delete [] idxList;
}

template <int SIZE, class TYPE>
void vuSphLfFlt_Line<SIZE,TYPE>::preview(int hint)
{
  dword *idxList = NULL;
  dword count    = 2;

  if (!getNearestViews(idxList, count)) return;
  if (count == 0) return;

  glPointSize(2.0);
  glColor3ub(255, 255, 0);

  glBegin(GL_LINES);
  for (dword i=0; i<count; i++) {
    vuVector lookFrom = m_volume->getView(idxList[i])->getLookFrom();
    glVertex3f(lookFrom[0], lookFrom[1], lookFrom[2]);
  }
  glEnd();
}

