#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_FitAngle_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_FitAngle_H_

#include "../vuSphericFilter.h"

/* takes every view that lays within a certain angle */

template <int SIZE, class TYPE>
class vuSphLfFlt_FitAngle : public vuSphericFilter<SIZE,TYPE>
{
 protected:
  using vuSphericFilter<SIZE,TYPE>::m_volume;
  using vuSphericFilter<SIZE,TYPE>::getNearestViews;
 public:
  vuSphLfFlt_FitAngle(const vuString& filterName);

  void calcFilteredViews(vuSphericView<SIZE,TYPE>**& views, dword& count);

  //! Set the view angle: range=[0 .. 180]
  void setAngle(float angle);

  //! Returns the angle (defaul=45)
  float getAngle();

 public:
  float    m_Angle;
};

template class vuSphLfFlt_FitAngle<1,byte>;
template class vuSphLfFlt_FitAngle<2,byte>;
template class vuSphLfFlt_FitAngle<3,byte>;
template class vuSphLfFlt_FitAngle<1,float>;
template class vuSphLfFlt_FitAngle<2,float>;
template class vuSphLfFlt_FitAngle<3,float>;

typedef vuSphLfFlt_FitAngle<1,byte>  vuSphLfFlt_FitAngle1B;
typedef vuSphLfFlt_FitAngle<2,byte>  vuSphLfFlt_FitAngle2B;
typedef vuSphLfFlt_FitAngle<3,byte>  vuSphLfFlt_FitAngle3B;
typedef vuSphLfFlt_FitAngle<1,float> vuSphLfFlt_FitAngle1F;
typedef vuSphLfFlt_FitAngle<2,float> vuSphLfFlt_FitAngle2F;
typedef vuSphLfFlt_FitAngle<3,float> vuSphLfFlt_FitAngle3F;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_FitAngle_H_ */
