#include "vuSphLfFlt_FitAngle.h"

template <int S, class T>
vuSphLfFlt_FitAngle<S,T>::vuSphLfFlt_FitAngle(const vuString& filterName)
  : vuSphericFilter<S,T>(filterName)
{
  m_Angle = 45.0;
}


template <int S, class T>
void vuSphLfFlt_FitAngle<S,T>::setAngle(float angle)
{
  if (angle <   0) angle =   0;
  if (angle > 180) angle = 180;

  m_Angle = angle;
}

template <int S, class T>
float vuSphLfFlt_FitAngle<S,T>::getAngle()
{
  return m_Angle;
}

template <int S, class T> void vuSphLfFlt_FitAngle<S,T>::
calcFilteredViews(vuSphericView<S,T>**& views,dword& count)
{
  CHECKNDELETE(views);
  count = 0;

  if (m_volume == NULL) return;
  
  float cosOfAngle = cos((m_Angle/180)*M_PI);
  dword numOfViews = m_volume->getNumberOfViews();
  vuVector lookAt  = m_volume->getCameraPtr()->getLookAtVector().makeUnit()*-1;
  dword  idxOfBest = 0;
  float  bestDot   = -1;
 
  if (numOfViews == 0) return;

  vuSphericView<S,T> **viewsTmp = NULL;

  viewsTmp = new vuSphericView<S,T>*[numOfViews];

  for (dword i=0; i<numOfViews; i++) {
    vuSphericView<S,T> *view = m_volume->getView(i);
    vuVector lookFrom = view->getLookFrom();
    float    dot      = lookFrom.dot(lookAt);
   
    if (dot > cosOfAngle) {
      viewsTmp[count] = view;
      count++;
    }
    if (bestDot < dot) {
      bestDot   = dot;
      idxOfBest = i;
    }
  }

  if (count == 0) {
    viewsTmp[count] = m_volume->getView(idxOfBest);
    count++;
  }
  
  views = new vuSphericView<S,T>*[count];
  for (dword i=0; i<count; i++) {
    views[i] =  viewsTmp[i];
  }
  CHECKNDELETE(viewsTmp);
}

