#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_BestMatch_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_BestMatch_H_

#include "../vuSphericFilter.h"
#include <GL/gl.h>

template <int SIZE, class TYPE>
class vuSphLfFlt_BestMatch : public vuSphericFilter<SIZE,TYPE>
{
 protected:
  using vuSphericFilter<SIZE,TYPE>::getNearestViews;
  using vuSphericFilter<SIZE,TYPE>::log;
  using vuSphericFilter<SIZE,TYPE>::m_volume;
 public:
  vuSphLfFlt_BestMatch(const vuString& filterName);

  //! This filter simple finds the best matching view
  void calcFilteredViews(vuSphericView<SIZE,TYPE>**& views, dword& count);
  
  //! preview
  virtual void preview(int hint);
};

template class vuSphLfFlt_BestMatch<1,byte>;
template class vuSphLfFlt_BestMatch<2,byte>;
template class vuSphLfFlt_BestMatch<3,byte>;
template class vuSphLfFlt_BestMatch<1,float>;
template class vuSphLfFlt_BestMatch<2,float>;
template class vuSphLfFlt_BestMatch<3,float>;

typedef vuSphLfFlt_BestMatch<1,byte>  vuSphLfFlt_BestMatch1B;
typedef vuSphLfFlt_BestMatch<2,byte>  vuSphLfFlt_BestMatch2B;
typedef vuSphLfFlt_BestMatch<3,byte>  vuSphLfFlt_BestMatch3B;
typedef vuSphLfFlt_BestMatch<1,float> vuSphLfFlt_BestMatch1F;
typedef vuSphLfFlt_BestMatch<2,float> vuSphLfFlt_BestMatch2F;
typedef vuSphLfFlt_BestMatch<3,float> vuSphLfFlt_BestMatch3F;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SphLfFlt_BestMatch_H_ */
