#include "vuSphLfFlt_BestMatch.h"
#include <GL/gl.h>

template <int S, class T>
vuSphLfFlt_BestMatch<S,T>::vuSphLfFlt_BestMatch(const vuString& filterName)
  : vuSphericFilter<S,T>(filterName)
{
}

template <int S, class T> void vuSphLfFlt_BestMatch<S,T>::
calcFilteredViews(vuSphericView<S,T>**& views,dword& count)
{
  dword *idxList = NULL;

  CHECKNDELETE(views);
  count = 1;

  if (!getNearestViews(idxList, count)) {
    CHECKNDELETE(idxList);
    count = 0;
    return log("vuSphLfFlt_BestMatch.filter(): no view found");
  }
  
  if (count == 0) {
    CHECKNDELETE(idxList);
    count = 0;
    return log("vuSphLfFlt_BestMatch.filter(): no view found");
  }
  
  count = 1;
  views = new vuSphericView<S,T>*[count];
  views[0] = m_volume->getView(idxList[0]);
  CHECKNDELETE(idxList);
}

template <int S, class T> void vuSphLfFlt_BestMatch<S,T>::preview(int hint)
{
  dword *idxList = NULL;
  dword count    = 1;

  cerr << "+" << endl;
  if (!getNearestViews(idxList, count)) return;
  if (count == 0) return;

  vuVector lookFrom = m_volume->getView(idxList[0])->getLookFrom();

  glPointSize(5.0);
  glColor3ub(255, 255, 0);

  glBegin(GL_POINTS);
  glVertex3f(lookFrom[0], lookFrom[1], lookFrom[2]);
  glEnd();
}
