#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_H_

#include "../unimodal.h"
#include "vuLightfield/vuSphericView.h"
#include "vuLinAlg/vuSpherical.h"
#include "vuLinAlg/vuMatrix.h"
#include <math.h>

/*!The base class template for lightfield unimodal spheric data in the
   vuVolume tree.
*/

class vu1611_ST : public vu161
{
 public:
  virtual dword getNumberOfViews(void) const = 0;
  virtual vuSphericView_ST *getView(dword i) = 0;
};

template <int SIZE, class TYPE>
class vu1611 : public vu1611_ST
{
public:
    //!The default constructor.
    vu1611();


    //!The copy constructor.
    vu1611(const vu1611& inst);

    //!The assignment operator.
    vu1611& operator=(const vu1611& rhs);

    ~vu1611();

    //!Returns the width of each view (all views have the same size).
    dword getWidth(void) const;

    //!Returns the height of each view (all views have the same size).
    dword getHeight(void) const;

    //!Returns the number of views.
    dword getNumberOfViews(void) const;

    //!Returns the ith view
    vuSphericView<SIZE,TYPE> *getView(dword i);

    int getIndexOfView(vuSphericView<SIZE,TYPE> * view);

    //!Returns the view array
    vuSphericView<SIZE,TYPE>* &getViews();

    const char *_typeName();

    //! this is deprecated and should not be supported anymore
    void setViewVectors(const vuVector&,const vuVector&,const vuVector&);

protected:
    /*!Asserts that the file is spheric data and reads the associated
      information.
    */

    /*!This method reads in the general information for spheric data sets.
      It also asserts whether the data is indeed spheric or not and 
      whether the data type is indeed from the correct TYPE and SIZE.

      \return True if successful (data is spheric), false otherwise.
    */
    virtual bool read(FILE *file);

    //!Writes the general spheric data information to the file.
    /*!\return True if successful, false otherwise.
     */
    virtual bool write(FILE *file);

    virtual void glResize(dword width, dword height);

private:

    void _initViews();

    //check data size
    bool _isDataSizeValid(dword dataSize);

    void _syncViewsToBuffer();

 public:

    //!Returns the center of the volume
    virtual vuVector getCenter() const;

 public:
    //!Reads volume data from the data file set with setFileName().
    /*!This implements the abstract read() method from the general Volume class.
      If the read is successful, the function returns true.  If the file does
      not exist or is in an invalid format, the function returns false.  In
      this case, the error information is set for the instance.
      \return True if successful, false otherwise.
    */
    virtual bool read(void);

    //!Writes volume data to the data file set with setFileName().
    /*!This implements the abstract write() method from the general Volume class.
      \return True if successful, false otherwise.
    */
    virtual bool write(void);

    bool write(const vuString &fileName);

 protected:
    //!The width of each view.
    dword m_width;
    //!The height of each view.
    dword m_height;
    //!The number of views.
    dword m_numberOfViews;
    //!The spheric views
    vuSphericView<SIZE,TYPE> *m_views;
};

template class vu1611<1,byte>;
template class vu1611<2,byte>;
template class vu1611<3,byte>;
template class vu1611<1,float>;
template class vu1611<2,float>;
template class vu1611<3,float>;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_H_ */

