#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_VUSPHERICINTERACTIVE_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_VUSPHERICINTERACTIVE_H_

/*! This is a helper class for interactive reconstruction, martin-2003-03-29

    It basically keeps track of already visited view indices and
    is able to determine the current (best fitting) view index, which
    is chosen from the current lightfieldVolume->getViewFilter()
*/

#include "ibr.h"

template <int SIZE, class TYPE>
class vuSphericInteractive{

 public:
  vuSphericInteractive();
  ~vuSphericInteractive();

  //!Sets the volume, on which the calculations are processed
  void setVolume(vu1611_2<SIZE,TYPE> *volume);

  //!Returns the volume
  vu1611_2<SIZE,TYPE> *getVolume();

  void reset();
  bool *getAlreadyVisitedIndices();
  int  indexOfNearestView();

  vuSphericView<SIZE,TYPE> *nearestView();

  bool vuSphericInteractive<SIZE,TYPE>::isVisited(dword idx);
  void vuSphericInteractive<SIZE,TYPE>::setIsVisited(dword idx, bool flag);

  dword getNumberOfVisited();

  dword getNumberOfViews();

 private:
  void _ensureList();
  
 protected:
  dword               m_NumberOfVisited; // how many views are already visited?
  dword               m_NumberOfViews;   // length of m_AlreadyVisited
  bool                *m_AlreadyVisited; // index list of already visited views
  vu1611_2<SIZE,TYPE> *m_Volume;
};

template class vuSphericInteractive<1,byte>;
template class vuSphericInteractive<2,byte>;
template class vuSphericInteractive<3,byte>;
template class vuSphericInteractive<1,float>;
template class vuSphericInteractive<2,float>;
template class vuSphericInteractive<3,float>;

typedef vuSphericInteractive<1,byte>  vuSphericInteractive1B;
typedef vuSphericInteractive<2,byte>  vuSphericInteractive2B;
typedef vuSphericInteractive<3,byte>  vuSphericInteractive3B;
typedef vuSphericInteractive<1,float> vuSphericInteractive1F;
typedef vuSphericInteractive<2,float> vuSphericInteractive2F;
typedef vuSphericInteractive<3,float> vuSphericInteractive3F;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_VUSPHERICINTERACTIVE_H_ */
