#include "vuSphericInteractive.h"

template <int SIZE, class TYPE>
vuSphericInteractive<SIZE,TYPE>::vuSphericInteractive()
{
  m_AlreadyVisited  = NULL;
  m_Volume          = NULL;
  m_NumberOfViews   = 0;
  m_NumberOfVisited = 0;
}

template <int SIZE, class TYPE>
vuSphericInteractive<SIZE,TYPE>::~vuSphericInteractive()
{
  CHECKNDELETE(m_AlreadyVisited);
  m_NumberOfViews   = 0;
  m_NumberOfVisited = 0;
  // m_Volume is outside living
}

template <int SIZE, class TYPE>
void vuSphericInteractive<SIZE,TYPE>::setVolume(vu1611_2<SIZE,TYPE> *volume)
{
  m_Volume = volume;
}

template <int SIZE, class TYPE>
vu1611_2<SIZE,TYPE> *vuSphericInteractive<SIZE,TYPE>::getVolume()
{
  return m_Volume;
}

template <int S, class T>
dword vuSphericInteractive<S,T>::getNumberOfVisited()
{
  return m_NumberOfVisited;
}

template <int S, class T>
dword vuSphericInteractive<S,T>::getNumberOfViews()
{
  return m_NumberOfViews;
}

template <int SIZE, class TYPE>
void vuSphericInteractive<SIZE,TYPE>::reset()
{  
  _ensureList();
  if (m_AlreadyVisited == NULL || m_NumberOfViews == 0) return;
  
  m_NumberOfVisited = 0;
  for (dword i=0; i<m_NumberOfViews; i++) {
    m_AlreadyVisited[i] = false;
  }
}

template <int SIZE, class TYPE>
bool vuSphericInteractive<SIZE,TYPE>::isVisited(dword idx)
{
  if (m_AlreadyVisited == NULL || m_NumberOfViews <= idx) return false;
  return m_AlreadyVisited[idx];
}

template <int SIZE, class TYPE>
void vuSphericInteractive<SIZE,TYPE>::setIsVisited(dword idx, bool flag)
{
  _ensureList();
  if (m_AlreadyVisited != NULL && idx < m_NumberOfViews) {
    if (!m_AlreadyVisited[idx] && flag) m_NumberOfVisited++;
    else if (m_AlreadyVisited[idx] && !flag) m_NumberOfVisited--;
    m_AlreadyVisited[idx] = flag;
  }
}


template <int S, class T>
void vuSphericInteractive<S,T>::_ensureList()
{
  if (m_Volume != NULL) {
    dword numOfViews = m_Volume->getNumberOfViews();
    
    if (m_NumberOfViews != numOfViews || m_AlreadyVisited == NULL) {
      m_NumberOfVisited = 0;
      m_NumberOfViews   = numOfViews;
      m_AlreadyVisited  = new bool[m_NumberOfViews];
    }
  }
}

template <int S, class T>
vuSphericView<S,T> *vuSphericInteractive<S,T>::nearestView()
{
  int idx = indexOfNearestView();
  
  if (idx > 0)
    return m_Volume->getView(idx);
  else
    return NULL;
}

template <int S, class T>
int vuSphericInteractive<S,T>::indexOfNearestView()
{
  if (m_Volume == NULL) return -1;

  vuVector               lookAt  = m_Volume->getCameraPtr()->getLookAtVector();

  vuSphericViewFilter<S,T> *filter  = m_Volume->getViewFilter();
  vuSphericView<S,T>       **views = filter->getViews();
  dword numberOfViews = filter->getNumberOfViews();

  dword *idxList = NULL;
  dword count   = 1;

  if (numberOfViews == 0) return -1; // no views available

  lookAt.makeUnit();
  lookAt *= -1;
  
  vuSphericFilter<S,T>::getNearestViews(idxList, count, lookAt, numberOfViews,
				     views);
  if (count != 1) {
    cerr << "WARNING: vuSimpleFBR._numberOfNearestView(): count != 1" << endl;
    return -2; // could not found the nearest one
  }
  dword result = idxList[0];
  CHECKNDELETE(idxList);

  numberOfViews = m_Volume->getNumberOfViews();
  dword idx     = numberOfViews;
  
  for (dword i=0; i<numberOfViews; i++) {
    if (m_Volume->getView(i) == views[result]) {
      idx = i;
      break;
    }
  }
  return idx;
}
