//! An Image Based Renderer for spherical lightfields

#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_IBR_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_IBR_H_

#include "../spheric.h"
#include "../vuSphericFilter.h"
#include "General/vuLightfield/vuSphericViewFilter.h"
#include "General/vuMisc/vuProgressHandler.h"

template <int SIZE, class TYPE>
class vu1611_2 : public vu1611<SIZE,TYPE>
{
protected:
  using vu1611<SIZE,TYPE>::m_Camera;
  using vu1611<SIZE,TYPE>::m_numberOfViews;
  using vu1611<SIZE,TYPE>::m_views;
public:
  vu1611_2();

  ~vu1611_2();

  //!Returns the lightfield filter (which choses the views)
  vuSphericFilter<SIZE,TYPE> *getFilter();

  //!Sets the filter
  //!\note filter MUST be newed, since vu1611_2 will delete it later
  void setFilter(vuSphericFilter<SIZE,TYPE> *filter);

  //!Sets the filter
  //!\note filter MUST be newed, since vu1611_2 will delete it later
  void setViewFilter(vuSphericViewFilter<SIZE,TYPE> *viewFilter);

  //!Returns the view filter
  vuSphericViewFilter<SIZE,TYPE> *getViewFilter();

  //! do some preprocesses (depends on the viewFilter)
  void preprocess(vuProgressHandler *handler=NULL);

  //!Initialize openGL
  virtual void initOpenGL(void);

  //!OpenGl Resize callback
  virtual void glResize(dword width, dword height);

  //!Renders the current view, depending on the camera
  virtual void render();

  //!computes the current image and returns it
  vuFixelMap<SIZE,TYPE>* computeAndReturnImage();

  //! set the default filter ("BestMatch")
  virtual bool read(void);

  //! preview
  void preview(int hint);

protected:
  //!The Spherical Filter (choses the views, on which should be interpolated)
  vuSphericFilter<SIZE,TYPE> *m_Filter;
  //! The Spherical View Filter (interpolates the chosen views)
  vuSphericViewFilter<SIZE,TYPE> *m_ViewFilter;
};


// creating some real classes for faster compilation

template class vu1611_2<1,byte>;
template class vu1611_2<2,byte>;
template class vu1611_2<3,byte>;
template class vu1611_2<1,float>;
template class vu1611_2<2,float>;
template class vu1611_2<3,float>;


typedef vu1611_2<1,byte>  vu161112;
typedef vu1611_2<2,byte>  vu161122;
typedef vu1611_2<3,byte>  vu161132;
typedef vu1611_2<1,float> vu1611A2;
typedef vu1611_2<2,float> vu1611B2;
typedef vu1611_2<3,float> vu1611C2;

typedef vu161112 vuVolumeLightfieldUnimodalSpheric1Bibr;
typedef vu161122 vuVolumeLightfieldUnimodalSpheric2Bibr;
typedef vu161132 vuVolumeLightfieldUnimodalSpheric3Bibr;
typedef vu1611A2 vuVolumeLightfieldUnimodalSpheric1Fibr;
typedef vu1611B2 vuVolumeLightfieldUnimodalSpheric2Fibr;
typedef vu1611C2 vuVolumeLightfieldUnimodalSpheric3Fibr;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_IBR_H_ */
