#include "ibr.h"
#include "../vuSphericFilterFactory.h"
#include "General/vuLightfield/vuSphericViewFilterFactory.h"

template <int SIZE, class TYPE>
vu1611_2<SIZE,TYPE>::vu1611_2()
{
  m_Filter     = NULL;
  m_ViewFilter = NULL;
  
  setFilter(vuSphericFilterFactory<SIZE,TYPE>::getFilter("BestMatch"));
  setViewFilter(vuSphericViewFilterFactory<SIZE,TYPE>::getFilter("Lazy"));
}

template <int SIZE, class TYPE>
vu1611_2<SIZE,TYPE>::~vu1611_2()
{
  CHECKNDELETE(m_Filter);
  CHECKNDELETE(m_ViewFilter);
}

template <int SIZE, class TYPE>
vuSphericFilter<SIZE,TYPE> *vu1611_2<SIZE,TYPE>::getFilter()
{
  return m_Filter;
}

template <int SIZE, class TYPE>
void vu1611_2<SIZE,TYPE>::setFilter(vuSphericFilter<SIZE,TYPE> *filter)
{
  if (filter == NULL) return;

  if (m_Filter != filter) {
    CHECKNDELETE(m_Filter);
    filter->setVolume(this);
    m_Filter = filter;
  }
}

template <int SIZE, class TYPE>
void vu1611_2<SIZE,TYPE>::setViewFilter(vuSphericViewFilter<SIZE,TYPE> *filter)
{
  if (filter == NULL) return;

  if (m_ViewFilter != filter) {
    CHECKNDELETE(m_ViewFilter);
    m_ViewFilter = filter;
  }
}

template <int SIZE, class TYPE>
vuSphericViewFilter<SIZE,TYPE> *vu1611_2<SIZE,TYPE>::getViewFilter()
{
  return m_ViewFilter;
}


template <int SIZE, class TYPE>
void vu1611_2<SIZE,TYPE>::preprocess(vuProgressHandler *handler)
{
  if (m_ViewFilter == NULL || m_Filter == NULL) return;
  
  if (m_ViewFilter->needPreprocessing()) {
    m_Filter->applyFilteredViews(m_ViewFilter);
    m_ViewFilter->preprocess(handler);
  }
}

template <int SIZE, class TYPE>
void vu1611_2<SIZE,TYPE>::initOpenGL(void)
{
  if (m_ViewFilter) m_ViewFilter->initOpenGL();
}

template <int SIZE, class TYPE>
void vu1611_2<SIZE,TYPE>::glResize(dword width, dword height)
{
  vu1611<SIZE,TYPE>::glResize(width, height);
  if (m_ViewFilter) m_ViewFilter->glResize(width, height);
}

template <int SIZE, class TYPE>
void vu1611_2<SIZE,TYPE>::render()
{
  if (m_ViewFilter == NULL) return;
  
  if (m_Filter && m_ViewFilter->needViewsForFiltering())
    m_Filter->applyFilteredViews(m_ViewFilter);

  m_ViewFilter->filter(m_Camera);
  m_ViewFilter->glRender();
}

template <int SIZE, class TYPE>
vuFixelMap<SIZE,TYPE>* vu1611_2<SIZE,TYPE>::computeAndReturnImage()
{
  if (m_ViewFilter == NULL) {
    cerr << "ibr::getImage(): view filter is not set" << endl;
    return NULL;
  }
  
  if (m_Filter && m_ViewFilter->needViewsForFiltering())
    m_Filter->applyFilteredViews(m_ViewFilter);

  m_ViewFilter->filter(m_Camera);

  return m_ViewFilter->getMap();
}

template <int SIZE, class TYPE>
bool vu1611_2<SIZE,TYPE>::read(void)
{
  if (!vu1611<SIZE,TYPE>::read()) return false;
  return true;
}

template <int SIZE, class TYPE>
void vu1611_2<SIZE,TYPE>::preview(int hint)
{
  if (m_Camera == NULL) {
    cerr << "ibr.preview() no camera set" << endl;
    return;
  }

  vuVector look = m_Camera->getLookAtVector().makeUnit()*-1;

  vuMatrix    rotX  = vuMatrix().makeRotateX(90);
  vuVector    tmp   = rotX * look;
  vuSpherical sph   = vuSpherical(tmp);
  float       alpha = (-sph.getLongitude() * 180 / M_PI) + 270;
  float       beta  = -((sph.getLatitude() * 180 / M_PI) - 90);

  //vuVector    up    = m_Camera->getUpVector().makeUnit();

  //    cerr << "tmp=" << look.getString() << endl;

  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();

#if 0
  glBegin(GL_LINES);
  glColor3ub(255,0,0);
  glVertex3f(0.0f,0.0f,0.0f);
  glVertex3f(1.0f,0.0f,0.0f);
  glColor3ub(0,255,0);
  glVertex3f(0.0f,0.0f,0.0f);
  glVertex3f(0.0f,1.0f,0.0f);
  glColor3ub(0,0,255);
  glVertex3f(0.0f,0.0f,0.0f);
  glVertex3f(0.0f,0.0f,1.0f);
  glColor3ub(255,255,0);
  glVertex3f(0.0f,0.0f,0.0f);
  glVertex3f(look[0],look[1],look[2]);
  glEnd();
#endif


  glRotatef(beta,  1.0f, 0.0f, 0.0f);
  glRotatef(alpha, 0.0f, 1.0f, 0.0f);

  //    glRotatef(10,    0.0f, 0.0f, 1.0f);

#if 1
  glPointSize(5.0);
  glColor3ub(255,0,255);
  glBegin(GL_POINTS);
  glVertex3f(look[0],look[1],look[2]);
  glEnd();
#endif

  glPointSize(1.0);

  glBegin(GL_POINTS);
  glColor3ub(255, 255, 255);

  for(dword i=0; i<m_numberOfViews; i++) {
    vuVector lookFrom = m_views[i].getLookFrom().makeUnit();
    if (look.dot(lookFrom) >= 0)
      glVertex3f(lookFrom[0], lookFrom[1], lookFrom[2]);
  }
  glEnd();

  if (m_Filter) m_Filter->preview(hint);

  glPopMatrix();
}
