/*! A spherical lightfield fourier browser allows to browse throw all
    frequency views of the ightfield and transforms each view back to
    to the spatial domain.
*/

#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_FOURIER_BROWSER_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_FOURIER_BROWSER_H_

#include "../Browser/browser.h"
#include <fftw.h>

template <int SIZE, class TYPE>
class vu1611_3 : public vu1611_1<SIZE,TYPE>
{
public:
  vu1611_3();

  ~vu1611_3();

  //!Renders the current view, depending on the camera
  virtual void render();

  //! set the default filter ("BestMatch")
  virtual bool read(void);


protected:
  using vu1611_1<SIZE,TYPE>::m_width;
  using vu1611_1<SIZE,TYPE>::m_height;
  using vu1611_1<SIZE,TYPE>::getCurrentView;
  //! this holds the forward plan needed by fttw
  vuFixelMap<SIZE,TYPE> *m_Map;
  fftwnd_plan            m_Plan;
  bool                   m_PlanExists;

  void _initPlanAndMap();
};


template class vu1611_3<1,byte>;
template class vu1611_3<2,byte>;
template class vu1611_3<3,byte>;

template class vu1611_3<1,float>;
template class vu1611_3<2,float>;
template class vu1611_3<3,float>;

typedef vu1611_3<1,byte> vu161113;
typedef vu1611_3<2,byte> vu161123;
typedef vu1611_3<3,byte> vu161133;

typedef vu1611_3<1,float> vu1611A3;
typedef vu1611_3<2,float> vu1611B3;
typedef vu1611_3<3,float> vu1611C3;

typedef vu161113 vuVolumeLightfieldUnimodalSpheric1BFourierBrowser;
typedef vu161123 vuVolumeLightfieldUnimodalSpheric2BFourierBrowser;
typedef vu161133 vuVolumeLightfieldUnimodalSpheric3BFourierBrowser;

typedef vu1611A3 vuVolumeLightfieldUnimodalSpheric1FFourierBrowser;
typedef vu1611B3 vuVolumeLightfieldUnimodalSpheric2FFourierBrowser;
typedef vu1611C3 vuVolumeLightfieldUnimodalSpheric3FFourierBrowser;

#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_FOURIER_BROWSER_H_ */
