//! An Fourier Based Renderer for spherical lightfields

#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_FBR_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_FBR_H_

#include "../IBR/ibr.h"
#include <fftw.h>

template <int SIZE, class TYPE>
class vu1611_4 : public vu1611_2<SIZE,TYPE>
{
public:
  vu1611_4();

  ~vu1611_4();

  //!Renders the current view, depending on the camera
  virtual void render();

  //! set the default filter ("BestMatch")
  virtual bool read(void);

protected:
  using vu1611_2<SIZE,TYPE>::m_ViewFilter;
  using vu1611_2<SIZE,TYPE>::m_Camera;
  using vu1611_2<SIZE,TYPE>::m_width;
  using vu1611_2<SIZE,TYPE>::m_height;
  //! this holds the forward plan needed by fttw
  vuFixelMap<SIZE,TYPE> *m_Map;
  fftwnd_plan            m_Plan;
  bool                   m_PlanExists;

  void _initPlanAndMap();
};

// creating some real classes for faster compilation

template class vu1611_4<1,byte>;
template class vu1611_4<2,byte>;
template class vu1611_4<3,byte>;
template class vu1611_4<1,float>;
template class vu1611_4<2,float>;
template class vu1611_4<3,float>;


typedef vu1611_4<1,byte>  vu161114;
typedef vu1611_4<2,byte>  vu161124;
typedef vu1611_4<3,byte>  vu161134;
typedef vu1611_4<1,float> vu1611A4;
typedef vu1611_4<2,float> vu1611B4;
typedef vu1611_4<3,float> vu1611C4;


typedef vu161114 vuVolumeLightfieldUnimodalSpheric1Bfbr;
typedef vu161124 vuVolumeLightfieldUnimodalSpheric2Bfbr;
typedef vu161134 vuVolumeLightfieldUnimodalSpheric3Bfbr;
typedef vu1611A4 vuVolumeLightfieldUnimodalSpheric1Ffbr;
typedef vu1611B4 vuVolumeLightfieldUnimodalSpheric2Ffbr;
typedef vu1611C4 vuVolumeLightfieldUnimodalSpheric3Ffbr;


#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_FBR_H_ */
