#include "fbr.h"

template <int SIZE, class TYPE> vu1611_4<SIZE,TYPE>::vu1611_4()
{
  m_Map        = NULL;
  m_PlanExists = false;
}

template <int SIZE, class TYPE> vu1611_4<SIZE,TYPE>::~vu1611_4()
{
  if (m_PlanExists) {
    fftwnd_destroy_plan(m_Plan);
    m_PlanExists = false;
  }
  CHECKNDELETE(m_Map);
}

//!Renders the current view, depending on the camera
template <int SIZE, class TYPE> void vu1611_4<SIZE,TYPE>::render()
{
  if (m_Map == NULL || !m_PlanExists)
    cerr << "fbr.render(): not properly initialized" << endl;
  else if (m_ViewFilter != NULL) {
    m_ViewFilter->filter(m_Camera);
    *m_Map = *m_ViewFilter->getMap();
    fftwnd_one(m_Plan, (fftw_complex*)m_Map->getBuffer(), NULL);
    *m_Map *= (float)(1/(float)(m_width*m_height)); // normalize 
    m_Map->glRender();
  }
}

template <int SIZE, class TYPE> bool vu1611_4<SIZE,TYPE>::read(void)
{
  if (!vu1611_2<SIZE,TYPE>::read()) return false;
  _initPlanAndMap();
  return true;
}

template <int SIZE, class TYPE> void vu1611_4<SIZE,TYPE>::_initPlanAndMap()
{
  cerr << "creating fttw plan...";
  if (m_PlanExists) fftwnd_destroy_plan(m_Plan);

  m_Plan = fftw2d_create_plan(m_height, m_width, FFTW_FORWARD,
			      FFTW_MEASURE | FFTW_IN_PLACE);
  m_PlanExists = true;
    
  CHECKNDELETE(m_Map);
  m_Map = new vuFixelMap<SIZE,TYPE>(m_height, m_width);
  cerr << " Done." << endl;
}
