//! A spherical lightfield browser allows to browse throw all views.

#ifndef _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_BROWSER_H_
#define _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_BROWSER_H_

#include "../spheric.h"

template <int SIZE, class TYPE>
class vu1611_1 : public vu1611<SIZE,TYPE>
{
public:
  //! default constructor
  vu1611_1();

  //!returns the currentView (best fitting view)
  vuSphericView<SIZE,TYPE> *getCurrentView();

  //! Sets the current view index
  void setViewIndex(dword idx);

  //!Get the current view index
  dword getViewIndex();

  //!Renders the current view, depending on the camera
  virtual void render();

  //!Initialize openGL
  virtual void initOpenGL(void);

  //!OpenGl Resize callback
  virtual void glResize(dword width, dword height);

  // get Map
  vuFixelMap<SIZE,TYPE> *getMap();

protected:
  //!number of current view
  dword m_viewIdx;
};

// creating some real classes for faster compilation

template class vu1611_1<1,byte>;
template class vu1611_1<2,byte>;
template class vu1611_1<3,byte>;

template class vu1611_1<1,float>;
template class vu1611_1<2,float>;
template class vu1611_1<3,float>;


typedef vu1611_1<1,byte> vu161111;
typedef vu1611_1<2,byte> vu161121;
typedef vu1611_1<3,byte> vu161131;

typedef vu1611_1<1,float> vu1611A1;
typedef vu1611_1<2,float> vu1611B1;
typedef vu1611_1<3,float> vu1611C1;

typedef vu161111 vuVolumeLightfieldUnimodalSpheric1BBrowser;
typedef vu161121 vuVolumeLightfieldUnimodalSpheric2BBrowser;
typedef vu161131 vuVolumeLightfieldUnimodalSpheric3BBrowser;
typedef vu1611A1 vuVolumeLightfieldUnimodalSpheric1FBrowser;
typedef vu1611B1 vuVolumeLightfieldUnimodalSpheric2FBrowser;
typedef vu1611C1 vuVolumeLightfieldUnimodalSpheric3FBrowser;


#endif /* _VU_VOLUME_LIGHTFIELD_UNIMODAL_SPHERIC_BROWSER_H_ */
