#include "browser.h"

template <int SIZE, class TYPE>
vu1611_1<SIZE,TYPE>::vu1611_1()
{
  m_viewIdx = 0;
}

template <int SIZE, class TYPE>
vuSphericView<SIZE,TYPE> *vu1611_1<SIZE,TYPE>::getCurrentView()
{
  return &this->m_views[m_viewIdx];
}


template <int SIZE, class TYPE>
void vu1611_1<SIZE,TYPE>::setViewIndex(dword idx)
{
  m_viewIdx = (idx >= this->m_numberOfViews) ? this->m_numberOfViews -1 : idx;
}


template <int SIZE, class TYPE>
dword vu1611_1<SIZE,TYPE>::getViewIndex()
{
  return m_viewIdx;
}


template <int SIZE, class TYPE>
void vu1611_1<SIZE,TYPE>::render()
{
  getCurrentView()->getMap()->glRender();
}

template <int SIZE, class TYPE>
vuFixelMap<SIZE,TYPE> *vu1611_1<SIZE,TYPE>::getMap()
{
  return getCurrentView()->getMap();
}



template <int SIZE, class TYPE>
void vu1611_1<SIZE,TYPE>::initOpenGL(void)
{
  getCurrentView()->getMap()->initOpenGL();
}


template <int SIZE, class TYPE>
void vu1611_1<SIZE,TYPE>::glResize(dword width, dword height)
{
  getCurrentView()->getMap()->glResize(width, height);
}
