#ifndef _VUVOLUMEIRREGULARUNIMODAL4D_H_
#define _VUVOLUMEIRREGULARUNIMODAL4D_H_

#include "../unimodal.h"

class vu1413;
typedef vu1413 vuVolumeIrregularUnimodal4d;

/** This is the base class from which Irregular, unimodal, 4D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1413 : public vu141
{
public:
	//! constructor
    vu1413();
    	//! copy constructor
    vu1413(vu1413& inst);
    	//! destructor
    virtual ~vu1413();

    	//! assignment operator
    vu1413& operator=(vu1413& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of the third dimension of the dataset
    int getDim3Size(void);
    	//! this will set the range of the fourth dimension of the dataset to be val
    void setDim4Size(int val);
    	//! this will return the range of the fourth dimension of the dataset
    int getDim4Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;
	//! this is the range of the fourth dimension of the dataset
    int m_Dim4Size;

};

#endif
