#ifndef _VUVOLUMEIRREGULARUNIMODAL3D_H_
#define _VUVOLUMEIRREGULARUNIMODAL3D_H_

#include "../unimodal.h"

class vu1412;
typedef vu1412 vuVolumeIrregularUnimodal3d;

/** This is the base class from which Irregular, unimodal, 2D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1412 : public vu141
{
public:
	//! cnstructor
    vu1412();
    	//!copy constructor
    vu1412(vu1412& inst);
    	//! destructor
    virtual ~vu1412();

    	//! assignment operator
    vu1412& operator=(vu1412& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of the third dimension of the dataset
    int getDim3Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;

};

#endif
