#ifndef _VUVOLUMEIRREGULARUNIMODAL2D_H_
#define _VUVOLUMEIRREGULARUNIMODAL2D_H_

#include "../unimodal.h"

class vu1411;
typedef vu1411 vuVolumeIrregularUnimodal2d;

/** This is the base class from which Irregular, unimodal, 2D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1411 : public vu141
{
public:
	//! constructor
    vu1411();
    	//! copy constructor
    vu1411(vu1411& inst);
    	//! destructor
    virtual ~vu1411();

    	//! assignment operator
    vu1411& operator=(vu1411& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;

};

#endif
