#ifndef _VUVOLUMEIRREGULARMULTIMODAL4D_H_
#define _VUVOLUMEIRREGULARMULTIMODAL4D_H_

#include "../multimodal.h"

class vu1423;
typedef vu1423 vuVolumeIrregularMultimodal4d;

/** This is the base class from which Irregular, multimodal, 4D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1423 : public vu142
{
public:
	//! constructor
    vu1423();
    	//! copy constructor
    vu1423(vu1423& inst);
    	//! destructor
    virtual ~vu1423();

    	//! assignment operator
    vu1423& operator=(vu1423& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of the third dimension of the dataset
    int getDim3Size(void);
    	//! this will set the range of the fourth dimension of the dataset to be val
    void setDim4Size(int val);
    	//! this will return the range of the fourth dimension of the dataset
    int getDim4Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;
	//! this is the range of the fourth dimension of the dataset
    int m_Dim4Size;

};

#endif
