#ifndef _VUVOLUMEIRREGULARMULTIMODAL3D_H_
#define _VUVOLUMEIRREGULARMULTIMODAL3D_H_

#include "../multimodal.h"

class vu1422;
typedef vu1422 vuVolumeIrregularMultimodal3d;

/** This is the base class from which Irregular, multimodal, 3D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1422 : public vu142
{
public:
	//! constructor
    vu1422();
    	//! copy constructor
    vu1422(vu1422& inst);
    	//! destructor
    virtual ~vu1422();

    	//! assignment operator
    vu1422& operator=(vu1422& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of the third dimension of the dataset
    int getDim3Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;

};

#endif
