#ifndef _VUVOLUMEIRREGULARMULTIMODAL2D_H_
#define _VUVOLUMEIRREGULARMULTIMODAL2D_H_

#include "../multimodal.h"

class vu1421;
typedef vu1421 vuVolumeIrregularMultimodal2d;

/** This is the base class from which Irregular, multimodal, 2D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1421 : public vu142
{
public:
	//! constructor
    vu1421();
    	//! copy constructor
    vu1421(vu1421& inst);
    	//! destructor
    virtual ~vu1421();

    	//! assignment operator
    vu1421& operator=(vu1421& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;

};

#endif
