#include "fourier.h"
#include <stdio.h>

//----------------------------------------------------------------------------
//------------------------- protected read() ---------------------------------
//----------------------------------------------------------------------------

bool vu17::read(FILE *file)
{
    int ret = 0;
    int len = 0;

    bool success = vu1::read(file);
    if (!success) return false;

    //Read in the Dataset type, checking if it's fourier
    ret = fscanf(file,"DATASET FOURIER %n",&len);
    if (len < 16) return setInvalidFormatError();

    return true;
}

//----------------------------------------------------------------------------
//------------------------- protected write() --------------------------------
//----------------------------------------------------------------------------

bool vu17::write(FILE *file)
{
    int ret = 0;

    bool success = vu1::write(file);
    if (!success) return false;

    //Write the Dataset type
    ret = fprintf(file,"DATASET FOURIER\n");
    
    if (ret > 0)
        return true;
    else
        return setWriteError();
}
