#ifndef _VUVOLUMEFOURIER_UNIMODAL_3d_STANDARDFVR_H_
#define _VUVOLUMEFOURIER_UNIMODAL_3d_STANDARDFVR_H_

#include "../3d.h"
#include "General/vuFourier/vuFourierVolume.h"

//! Implements the standard FVR rendering method

template <int SIZE>
class vu1712_1 : public vu1712<SIZE>, public vuFourierVolume<SIZE>
{
protected:
    using vu1712<SIZE>::m_Camera;
    using vuFourierVolume<SIZE>::m_Volume;
    using vu1712<SIZE>::m_FileName;
    using vuFourierVolume<SIZE>::m_XSize;
    using vuFourierVolume<SIZE>::m_YSize;
    using vuFourierVolume<SIZE>::m_ZSize;
    using vuFourierVolume<SIZE>::m_Wrap;
    using vu1712<SIZE>::m_Dim1Size;
    using vu1712<SIZE>::m_Dim2Size;
    using vu1712<SIZE>::m_Dim3Size;

public:
    using vu1712<SIZE>::readHeader;
    using vuFourierVolume<SIZE>::setWrap;
    using vuFourierVolume<SIZE>::wrapAndInitialize;
    using vu1712<SIZE>::setError;
    using vu1712<SIZE>::writeHeader;

public:
    vu1712_1();
    ~vu1712_1();

    virtual bool read(void);
    virtual bool write(void);

    // Empty implementation...
    void setViewVectors (const vuVector &lookAt,
			 const vuVector &up,
			 const vuVector &right);

    void render();

    void glResize(dword width, dword height);

    void setIsReRendering(bool flag);
    bool getIsReRendering();
};

template class vu1712_1<1>;
template class vu1712_1<2>;
template class vu1712_1<3>;

typedef vu1712_1<1> vu1712A1;
typedef vu1712_1<2> vu1712B1;
typedef vu1712_1<3> vu1712C1;

typedef vu1712A1 vuVolumeFourierUnimodal3dStandardFVRA;
typedef vu1712B1 vuVolumeFourierUnimodal3dStandardFVRB;
typedef vu1712C1 vuVolumeFourierUnimodal3dStandardFVRC;

#endif
