#include "StandardFVR.h"
#include "General/vuCamera/vuParallelCamera.h"

using namespace std;

#define MAX_FILTER_WIDTH 6

template <int SIZE>
vu1712_1<SIZE>::vu1712_1()
{
  m_Camera       = new vuParallelCamera();
  m_Camera->setPosition(m_Camera->getLookAtVector() * -1);
  m_Camera->init();
}

//----------------------------------------------------------------------------
//------------------------- public read() ------------------------------------
//----------------------------------------------------------------------------

template <int SIZE>
vu1712_1<SIZE>::~vu1712_1()
{
  CHECKNDELETE(m_Camera);
}

template <int SIZE>
bool vu1712_1<SIZE>::read(void)
{
  if (m_FileName.isEmpty()) return setError("No file name specified.");

  FILE *file = fopen(m_FileName,"rb");
  if (file != NULL)
    {
      bool success = readHeader(file);

      if (!success) {
	fclose(file);
	return false;
      }

      setWrap(MAX_FILTER_WIDTH/2);

      m_XSize = m_Dim1Size + m_Wrap * 2;
      m_YSize = m_Dim2Size + m_Wrap * 2;
      m_ZSize = m_Dim3Size + m_Wrap * 2;

      m_Volume = new float[m_XSize * m_YSize * m_ZSize * 2 * SIZE];

      success = readData(file, m_Volume,
			 m_XSize, m_YSize, m_ZSize,
			 m_Dim1Size, m_Dim2Size, m_Dim3Size);
      wrapAndInitialize(1.0);

      fclose(file);
      return success;
    }
  else
    return setError("Could not open the specified file.");
}

//----------------------------------------------------------------------------
//------------------------- public write() -----------------------------------
//----------------------------------------------------------------------------

template <int SIZE>
bool vu1712_1<SIZE>::write(void)
{
  if (m_FileName.isEmpty()) return setError("No file name specified.");
    
  FILE *file = fopen(m_FileName,"wb");
  if (file != NULL)
    {
      bool success = writeHeader(file);
	
      if (success) {
	writeData(file, m_Volume,
		  m_XSize, m_YSize, m_ZSize,
		  m_Dim1Size, m_Dim2Size, m_Dim3Size);
      }

      fclose(file);
      return success;
    }
  else
    return setError("Could not open the specified file.");
}

template <int SIZE>
void vu1712_1<SIZE>::render()
{
  vuFourierVolume<SIZE>::setCamera(m_Camera);
  vuFourierVolume<SIZE>::render();
}

template <int SIZE>
void vu1712_1<SIZE>::setViewVectors(const vuVector& lookAt,
				    const vuVector& up,
				    const vuVector& right)
{
  vuFourierVolume<SIZE>::setViewVectors(lookAt, up, right);
}


template <int SIZE>
void vu1712_1<SIZE>::glResize(dword width, dword height)
{
  vuFourierVolume<SIZE>::glResize(width, height);
  if (m_Camera != NULL) {
    m_Camera->setWidth(width);
    m_Camera->setHeight(height);
    m_Camera->init();    
  }
}

template <int SIZE>
void vu1712_1<SIZE>::setIsReRendering(bool flag)
{
  vuFourierVolume<SIZE>::setIsReRendering(flag);
}

template <int SIZE>
bool vu1712_1<SIZE>::getIsReRendering()
{
  return vuFourierVolume<SIZE>::getIsReRendering();
}
