#ifndef _VUVOLUMEFOURIERUNIMODAL3D_H_
#define _VUVOLUMEFOURIERUNIMODAL3D_H_

#include "../unimodal.h"

//!The base class for fourier unimodal 3d data in the vuVolume data tree.

template <int SIZE>
class vu1712 : public vu171
{
public:
    //!The default constructor.
    vu1712();
    //!The copy constructor.
    vu1712(const vu1712<SIZE>& inst);

    //!The assignment operator.
    vu1712<SIZE>& operator=(const vu1712<SIZE>& rhs);

    //!Returns the size of the data along the first dimension.
    dword getDim1Size(void) const;
    //!Returns the size of the data along the second dimension.
    dword getDim2Size(void) const;
    //!Returns the size of the data along the third dimension.
    dword getDim3Size(void) const;

    //!Returns the spacing of the 3d grid.
    /*!This is the spacing between the data values in each of the dimensions.
       This value is uniform in all dimensions since this is a fourier grid.
    */
    dword getSpacing(void) const;

    //!Returns the origin of the data in the first dimension.
    int getDim1Origin(void) const;
    //!Returns the origin of the data in the second dimension.
    int getDim2Origin(void) const;
    //!Returns the origin of the data in the third dimension.
    int getDim3Origin(void) const;

    //!returns the center of the dataset (virtual in volume.h)
    vuVector getCenter() const {
	return vuVector((float)m_Dim1Size/2,(float)m_Dim2Size/2,(float)m_Dim3Size/2);
    }

protected:
    virtual bool readHeader(FILE *file);
    virtual bool writeHeader(FILE *file);

public:
    static bool readData(FILE *file, float* vol,
			 dword XX, dword YY, dword ZZ,
			 dword XXsmall, dword YYsmall, dword ZZsmall);


    static bool writeData(FILE *file, float* vol,
			  dword XX, dword YY, dword ZZ,
			  dword XXsmall, dword YYsmall, dword ZZsmall);

    static float* pad(float* v, dword n);

    static bool writeHeader(FILE *file, dword XSize, dword YSize, dword ZSize);
    static bool readHeader(FILE *file,dword &XSize,dword &YSize,dword &ZSize);

protected:
    //!The size of the first dimension of the data set.
    dword m_Dim1Size;
    //!the sizeof the second dimension of the data set
    dword m_Dim2Size;
    //! the size of the third dimension of the data set
    dword m_Dim3Size;

    //!The spacing of the grid.
    dword m_Spacing;

    //!The origin of the first dimension of the data set.
    int m_Dim1Origin;
	//! The origin of the second dimensino of the data set
    int m_Dim2Origin;
    	//! the origin of the third dimension of the data set
    int m_Dim3Origin;
};


template class vu1712<1>;
template class vu1712<2>;
template class vu1712<3>;

typedef vu1712<1> vu1712A;
typedef vu1712<2> vu1712B;
typedef vu1712<3> vu1712C;

typedef vu1712A vuVolumeFourierUnimodal3dA;
typedef vu1712B vuVolumeFourierUnimodal3dB;
typedef vu1712C vuVolumeFourierUnimodal3dC;

#endif
