#ifndef _VUVOLUMECURVILINEARUNIMODAL4D_H_
#define _VUVOLUMECURVILINEARUNIMODAL4D_H_

#include "../unimodal.h"

class vu1313;
typedef vu1313 vuVolumeCurvilinearUnimodal4d;

/** this is the base class from which Curvilinear, unimodal, 3d renderers are derived.
This will provide the functionality to handle the range of the dataset in each dimension */
class vu1313 : public vu131
{
public:
	//! constructor
    vu1313();
    	//! copy constructor
    vu1313(vu1313& inst);

    	//! destructor
    virtual ~vu1313();

    	//! assignment operator
    vu1313& operator=(vu1313& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of third dimension of the dataset
    int getDim3Size(void);
    	//! this will set the range of the fourth dimension of the dataset to be val
    void setDim4Size(int val);
    	//! this will return the range of fourth dimension of the dataset
    int getDim4Size(void);

protected:
	//! this is the range of the first dimesnion of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimesnion of the dataset
    int m_Dim2Size;
	//! this is the range of the third dimesnion of the dataset
    int m_Dim3Size;
	//! this is the range of the fourth dimesnion of the dataset
    int m_Dim4Size;

};

#endif
