#ifndef _VUVOLUMECURVILINEARUNIMODAL3D_H_
#define _VUVOLUMECURVILINEARUNIMODAL3D_H_

#include "../unimodal.h"

class vu1312;
typedef vu1312 vuVolumeCurvilinearUnimodal3d;

/** this is the base class from which Curvilinear, unimodal, 3d renderers are derived.
This will provide the functionality to handle the range of the dataset in each dimension */
class vu1312 : public vu131
{
public:
	//! constructor
    vu1312();
    	//! copy constructor
    vu1312(vu1312& inst);
    	//! destructor
    virtual ~vu1312();

    	//! assignment operator
    vu1312& operator=(vu1312& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of third dimension of the dataset
    int getDim3Size(void);

protected:
	//! this is the range of the first dimesnion of the dataset
    int m_Dim1Size;
    	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
    	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;

};

#endif
