#ifndef _VUVOLUMECURVILINEARUNIMODAL2D_H_
#define _VUVOLUMECURVILINEARUNIMODAL2D_H_

#include "../unimodal.h"

class vu1311;
typedef vu1311 vuVolumeCurvilinearUnimodal2d;

/** This is the base class from which curvlinear, unimodal, 2D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1311 : public vu131
{
public:
	//! constructor
    vu1311();
    	//! copy constructor
    vu1311(vu1311& inst);
    	//! destructor
    virtual ~vu1311();

    	//! assignment operator
    vu1311& operator=(vu1311& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the datasaet
    int getDim2Size(void);

protected:
	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
    	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;

};

#endif
