#ifndef _VUVOLUMECURVILINEARMULTIMODAL3D_H_
#define _VUVOLUMECURVILINEARMULTIMODAL3D_H_

#include "../multimodal.h"

class vu1322;
typedef vu1322 vuVolumeCurvilinearMultimodal3d;

/** This is the base class from which curvlinear, multimodal, 3D renderers will be derived
This provides the functionality to handle the range of the dataset in each dimension */
class vu1322 : public vu132
{
public:
	//! constructor
    vu1322();
    	//! copy constructor
    vu1322(vu1322& inst);
    	//! destructor
    virtual ~vu1322();

    	//! assignment operator
    vu1322& operator=(vu1322& rhs);

    	//! this will set the range of the first dimension of the dataset to be val
    void setDim1Size(int val);
    	//! this will return the range of the first dimension of the dataset
    int getDim1Size(void);
    	//! this will set the range of the second dimension of the dataset to be val
    void setDim2Size(int val);
    	//! this will return the range of the second dimension of the dataset
    int getDim2Size(void);
    	//! this will set the range of the third dimension of the dataset to be val
    void setDim3Size(int val);
    	//! this will return the range of the third dimension of the dataset
    int getDim3Size(void);

protected:

	//! this is the range of the first dimension of the dataset
    int m_Dim1Size;
	//! this is the range of the second dimension of the dataset
    int m_Dim2Size;
	//! this is the range of the third dimension of the dataset
    int m_Dim3Size;

};

#endif
